$(document).ready(function(){	
	var employeeData = $('#employeeList').DataTable({
		"lengthChange": true,
		"processing":true,
		"serverSide":true,
		"responsive": true,
		"order":[],
		"ajax":{
			url:"action.php",
			type:"POST",
			data:{action:'listEmployee'},
			dataType:"json"
		},
		"createdRow": function( row, data, dataIndex){
                if(( data[7] !==  '')&&( data[7] !==  '0') ){
                    $(row).addClass('redClass');
                }
            },
		"columnDefs":[
			{
				"targets":[0, 6],
				"orderable":false,
			},
		],
		"pageLength": 30
	});	
	
//var table = $('#example').DataTable();
 
employeeData.on( 'draw', function () {
   // alert( 'Table redrawn' );
   $('.dataTables_length').parent().remove();
   $('#employeeList_filter input').css("width","600px");
} );	
	
	
	$('#addEmployee').click(function(){
		$('#employeeModal').modal('show');
		$('#employeeForm')[0].reset();
		$('.modal-title').html("<i class='fa fa-plus'></i> Add Employee");
		$('#action').val('addEmployee');
		$('#save').val('Add');
	});		
	$("#employeeList").on('click', '.update', function(){
		var empcodigo = $(this).attr("codigo");
		var action = 'getEmployee';
		$.ajax({
			url:'action.php',
			method:"POST",
			data:{empcod:empcodigo, action:action},
			dataType:"json",
			success:function(data){
				$('#employeeModal').modal('show');
				$('#empcodigo').val(data.codigo);
				$('#empnombre').val(data.nombre);
				$('#empcargo').val(data.cargo);
				$('#empcedula').val(data.cedula);				
				$('#ubicacion').val(data.ubicacion);
				$('#zona').val(data.zona);	
				$('.modal-title').html("<i class='fa fa-plus'></i> Edit Employee");
				$('#action').val('updateEmployee');
				$('#save').val('Save');
			}
		})
	});
	$("#employeeModal").on('submit','#employeeForm', function(event){
		event.preventDefault();
		$('#save').attr('disabled','disabled');
		var formData = $(this).serialize();
		$.ajax({
			url:"action.php",
			method:"POST",
			data:formData,
			success:function(data){				
				$('#employeeForm')[0].reset();
				$('#employeeModal').modal('hid	e');				
				$('#save').attr('disabled', false);
				employeeData.ajax.reload();
			}
		})
	});		
	$("#employeeList").on('click', '.delete', function(){
		var empcodigo = $(this).attr("codigo");		
		var action = "empDelete";
		if(confirm("Are you sure you want to delete this employee?")) {
			$.ajax({
				url:"action.php",
				method:"POST",
				data:{empcodigo:empcodigo, action:action},
				success:function(data) {					
					employeeData.ajax.reload();
				}
			})
		} else {
			return false;
		}
	});	
	$('table').css('width','100% !important')
});